/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters;

import java.util.function.Predicate;
import me.towdium.jecharacters.config.JechConfig;
import me.towdium.jecharacters.utils.Match;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class JechConfigForge {
    public static ModConfigSpec common;
    public static ModConfigSpec.BooleanValue enableQuote;
    public static ModConfigSpec.EnumValue<JechConfig.Spell> enumKeyboard;
    public static ModConfigSpec.BooleanValue enableFZh2z;
    public static ModConfigSpec.BooleanValue enableFSh2s;
    public static ModConfigSpec.BooleanValue enableFCh2c;
    public static ModConfigSpec.BooleanValue enableFAng2an;
    public static ModConfigSpec.BooleanValue enableFIng2in;
    public static ModConfigSpec.BooleanValue enableFEng2en;
    public static ModConfigSpec.BooleanValue enableFU2v;
    public static ModConfigSpec.BooleanValue enableVerbose;
    public static ModConfigSpec.BooleanValue enableChat;

    static void register(IEventBus modBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)common);
        modBus.addListener(ModConfigEvent.Loading.class, event -> JechConfigForge.refresh());
        modBus.addListener(ModConfigEvent.Reloading.class, event -> JechConfigForge.refresh());
    }

    public static void refresh() {
        JechConfig.enableQuote = (Boolean)enableQuote.get();
        JechConfig.enumKeyboard = (JechConfig.Spell)((Object)enumKeyboard.get());
        JechConfig.enableFZh2z = (Boolean)enableFZh2z.get();
        JechConfig.enableFSh2s = (Boolean)enableFSh2s.get();
        JechConfig.enableFCh2c = (Boolean)enableFCh2c.get();
        JechConfig.enableFAng2an = (Boolean)enableFAng2an.get();
        JechConfig.enableFIng2in = (Boolean)enableFIng2in.get();
        JechConfig.enableFEng2en = (Boolean)enableFEng2en.get();
        JechConfig.enableFU2v = (Boolean)enableFU2v.get();
        JechConfig.enableVerbose = (Boolean)enableVerbose.get();
        JechConfig.enableChat = (Boolean)enableChat.get();
        Match.onConfigChange();
    }

    static {
        Predicate<Object> p = i -> i instanceof String;
        ModConfigSpec.Builder b = new ModConfigSpec.Builder();
        b.push("General");
        b.comment("Keyboard for the checker to use");
        enumKeyboard = b.defineEnum("enumKeyboard", (Enum)JechConfig.Spell.QUANPIN);
        b.comment("Set to true to enable fuzzy spelling zh <=> z");
        enableFZh2z = b.define("enableFZh2z", true);
        b.comment("Set to true to enable fuzzy spelling sh <=> s");
        enableFSh2s = b.define("enableFSh2s", true);
        b.comment("Set to true to enable fuzzy spelling ch <=> c");
        enableFCh2c = b.define("enableFCh2c", true);
        b.comment("Set to true to enable fuzzy spelling ang <=> an");
        enableFAng2an = b.define("enableFAng2an", true);
        b.comment("Set to true to enable fuzzy spelling ing <=> in");
        enableFIng2in = b.define("enableFIng2in", true);
        b.comment("Set to true to enable fuzzy spelling eng <=> en");
        enableFEng2en = b.define("enableFEng2en", true);
        b.comment("Set to true to enable fuzzy spelling u <=> v");
        enableFU2v = b.define("enableFU2v", true);
        b.comment("Set to false to disable chat message when entering world");
        enableChat = b.define("enableChat", true);
        b.comment("Set to true to disable JEI's split for search tokens");
        enableQuote = b.define("enableQuote", false);
        b.pop();
        b.push("Utilities");
        b.comment("Set true to print verbose debug message");
        enableVerbose = b.define("enableVerbose", false);
        b.pop();
        common = b.build();
    }
}

